<?php

namespace App\Http\Controllers\API\Therapists;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\TherapistExperience;
use App\Http\Requests\API\Therapists\TherapistExperiences\CreateRequest;
use App\Http\Resources\API\TherapistExperiencesResource;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class TherapistExperiencesController extends Controller
{
    /********* Initialize Permission based Middlewares  ***********/
  public function __construct()
  {
        $this->middleware(['api','auth:api','verified','api_setting']);
        $this->middleware('therapist.api');
      // $this->middleware('permission:therapist_experiences.index');
      // $this->middleware('permission:therapist_experiences.create',['only' => ['store']]);
      // $this->middleware('permission:therapist_experiences.update',['only' => ['update']]);
      // $this->middleware('permission:therapist_experiences.delete',['only' => ['destroy']]);
      // $this->middleware('permission:therapist_experiences.export',['only' => ['export']]);
      // $this->middleware('permission:therapist_experiences.import',['only' => ['import']])
      // $this->middleware('permission:therapist_experiences.update|therapist_experiences.is_active',['only' => ['updateStatus']]);
  }

  /********* Getter For Pagination, Searching And Sorting  ***********/
  public function getter($req = null,$export = null)
  {
    $therapist = auth()->user()->therapist;
    if($req != null){
      $therapist_experiences =  $therapist->therapist_experiences()->withAll();
      if($req->trash && $req->trash == 'with'){
        $therapist_experiences =  $therapist_experiences->withTrashed();
      }
      if($req->trash && $req->trash == 'only'){
        $therapist_experiences =  $therapist_experiences->onlyTrashed();
      }
      if($req->column && $req->column != null && $req->search != null){
          $therapist_experiences = $therapist_experiences->whereLike($req->column,$req->search);
        }
       else if($req->search && $req->search != null){

            $therapist_experiences = $therapist_experiences->whereLike(['name','description'],$req->search);
        }
      if($req->sort && $req->sort['field'] != null && $req->sort['type'] != null){
          $therapist_experiences = $therapist_experiences->OrderBy($req->sort['field'],$req->sort['type']);
      }
      else
      {
        $therapist_experiences = $therapist_experiences->OrderBy('id','desc');
      }
      if($export != null){ // for export do not paginate
        $therapist_experiences = $therapist_experiences->get();
        return $therapist_experiences;
      }
      $totalTherapistCertifications = $therapist_experiences->count();
      $therapist_experiences = $therapist_experiences->paginate($req->perPage);
      $therapist_experiences = TherapistExperiencesResource::collection($therapist_experiences)->response()->getData(true);

      return $therapist_experiences;
    }
    $therapist_experiences = TherapistExperiencesResource::collection($therapist->therapist_experiences()->withAll()->orderBy('id','desc')->paginate(10))->response()->getData(true);
    return $therapist_experiences;
  }

  /********* FETCH ALL Therapist Experiences ***********/
    public function index()
    {
        $therapist_experiences =  $this->getter();
        $response = generateResponse($therapist_experiences,count($therapist_experiences['data']) > 0 ? true:false,'Therapist Experiences Fetched Successfully',null,'collection');
        return response()->json($response, 200);
    }

  /********* FILTER Therapist Experiences FOR Search ***********/
   public function filter(Request $request){
     $therapist_experiences = $this->getter($request);
     $response = generateResponse($therapist_experiences,count($therapist_experiences['data']) > 0 ? true:false,'Filter Therapist Experiences Successfully',null,'collection');
     return response()->json($response, 200);
   }

    /********* ADD NEW Therapist Experience ***********/
    public function store(CreateRequest $request)
    {
      $therapist = auth()->user()->therapist;
      try{
        DB::beginTransaction();
        $request->merge(['therapist_id'=>auth()->user()->id]);
        $data = $request->all();
        $data['image'] = uploadFile($request,'file','therapist_experiences');
        $therapist_experience = $therapist->therapist_experiences()->create($data);
        DB::commit();
        $therapist_experience = $therapist->therapist_experiences()->withAll()->find($therapist_experience->id);
        $therapist_experience = new TherapistExperiencesResource($therapist_experience);
      $response = generateResponse($therapist_experience,true ,'Therapist Experiences Created Successfully',null,'collection');
      return response()->json($response, 200);
    }
      catch (\Exception $e) {
        DB::rollBack();
        $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
        return response()->json($response, 200);
     }
    }

    /********* View RECORD TO EDIT Or Display ***********/
    public function show(TherapistExperience $therapist_experience)
    {
        $therapist = auth()->user()->therapist;
        if($therapist_experience->therapist_id != $therapist->id){
          $response = generateResponse(null,false ,'Not Found',null,'collection');
          return response()->json($response, 404);
        }
        $therapist_experience = $therapist->therapist_experiences()->withAll()->find($therapist_experience->id);
        if($therapist_experience){
          $therapist_experience = new TherapistExperiencesResource($therapist_experience);
          $response = generateResponse($therapist_experience,true,'Therapist Experience Fetched Successfully',null,'object');
        }
        else{
          $response = generateResponse(null,false,'Therapist Experience Not Found',null,'object');
        }
        return response()->json($response, 200);
    }

    /********* UPDATE Therapist Experience ***********/
    public function update(CreateRequest $request, TherapistExperience $therapist_experience)
    {
        // dd($request->all());
        $therapist = auth()->user()->therapist;
        if($therapist_experience->therapist_id != $therapist->id){
          $response = generateResponse(null,false ,'Not Found',null,'collection');
          return response()->json($response, 404);
        }
      try{
        DB::beginTransaction();
        $request->merge(['last_updated_by_user_id'=>auth()->user()->id]);
        $data = $request->all();
        if ($request->file) {
            $data['image'] = uploadFile($request,'file','therapist_experiences',$therapist_experience->image);
        } else {
            $data['image'] = $therapist_experience->image;
        }
        $therapist_experience->update($data);
        DB::commit();
        $therapist_experience = $therapist->therapist_experiences()->withAll()->find($therapist_experience->id);
        $therapist_experience = new TherapistExperiencesResource($therapist_experience);
        $response = generateResponse($therapist_experience,true,'Therapist Experience Updated Successfully',null,'object');
        return response()->json($response, 200);
      }
        catch (\Exception $e) {
          DB::rollBack();
          $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
          return response()->json($response, 200);
       }
    }

    /********* UPDATE Therapist Experience Status***********/
    public function updateStatus(Request $request,TherapistExperience $therapist_experience){
      try{
        $therapist = auth()->user()->therapist;
        if($therapist_experience->therapist_id != $therapist->id){
          $response = generateResponse(null,false ,'Not Found',null,'collection');
          return response()->json($response, 404);
        }
        $therapist_experience->update([
          'is_active' => $therapist_experience->is_active == 1 ? 0:1
        ]);
        $response = generateResponse(null,true,'Therapist Experience Status Updated Successfully',null,'object');
        return response()->json($response, 200);
      }
      catch (\Exception $e) {
        DB::rollBack();
        $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
        return response()->json($response, 200);
     }
    }


    /********* DELETE Therapist Experience ***********/
    public function destroy(Request $request,TherapistExperience $therapist_experience)
    {
      try{
        $therapist = auth()->user()->therapist;
        if($therapist_experience->therapist_id != $therapist->id){
          $response = generateResponse(null,false ,'Not Found',null,'collection');
          return response()->json($response, 404);
        }
          if($therapist_experience->trashed()) {
            $response = generateResponse(null,false ,'Already in Trash',null,'collection');
            return response()->json($response, 404);
          }
          else{
            $therapist_experience->delete();
          }
          $response = generateResponse(null,true,'Therapist Experience Deleted Successfully',null,'object');
          return response()->json($response, 200);

        } catch (\Exception $e) {
          DB::rollBack();
          $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
          return response()->json($response, 200);
       }
    }
    /*********Permanently DELETE Therapist Experience ***********/
    public function destroyPermanently(Request $request,$therapist_experience)
    {
      try{
        $therapist= auth()->user()->therapist;
        $therapist_experience = $therapist->therapist_experiences()->withTrashed()->find($therapist_experience);
        if($therapist_experience){
            if($therapist_experience->therapist_id != $therapist->id){
              $response = generateResponse(null,false ,'Not Found',null,'collection');
              return response()->json($response, 404);
            }
          if ($therapist_experience->trashed()) {
            $therapist_experience->forceDelete();
            $response = generateResponse(null,true,'Therapist Experience Deleted Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'Therapist Experience is not in trash to delete permanently',null,'object');
          }
        }
        else{
          $response = generateResponse(null,false,'Therapist Experience not found',null,'object');
        }
          return response()->json($response, 200);

        } catch (\Exception $e) {
          DB::rollBack();
          $response = generateResponse(null,false ,$e->getMessage(),null,'collection');
          return response()->json($response, 200);
       }
    }
    /********* Restore Therapist Experience ***********/
    public function restore(Request $request,$therapist_experience)
    {
      $therapist= auth()->user()->therapist;
      $therapist_experience = $therapist->therapist_experiences()->withTrashed()->find($therapist_experience);
          if ($therapist_experience->trashed()) {
            $therapist_experience->restore();
            $response = generateResponse(null,true,'Therapist Experience Restored Successfully',null,'object');
          }
          else{
            $response = generateResponse(null,false,'Therapist Experience is not trashed',null,'object');
          }
          return response()->json($response, 200);
    }
}
